"""
Auto-generated configuration helper functions from shared_config.py
DO NOT EDIT THIS FILE MANUALLY - it will be overwritten on build
"""

from typing import Dict, Any
from .config_schema_generated import ConfigurationData, ALL_FIELDS


def log_configuration_update(logger, config: ConfigurationData) -> None:
    """Log configuration update with all field values"""
    logger.info(f"Updated lsfg TOML configuration: dll={config['dll']}, no_fp16={config['no_fp16']}, multiplier={config['multiplier']}, flow_scale={config['flow_scale']}, performance_mode={config['performance_mode']}, hdr_mode={config['hdr_mode']}, experimental_present_mode={config['experimental_present_mode']}, dxvk_frame_rate={config['dxvk_frame_rate']}, enable_wow64={config['enable_wow64']}, disable_steamdeck_mode={config['disable_steamdeck_mode']}, mangohud_workaround={config['mangohud_workaround']}, disable_vkbasalt={config['disable_vkbasalt']}, force_enable_vkbasalt={config['force_enable_vkbasalt']}, enable_wsi={config['enable_wsi']}, enable_zink={config['enable_zink']}")


def get_config_field_names() -> list[str]:
    """Get all configuration field names"""
    return ALL_FIELDS.copy()


def extract_config_values(config: ConfigurationData) -> Dict[str, Any]:
    """Extract configuration values as a dictionary"""
    return {field: config[field] for field in ALL_FIELDS}
